<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">

    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Dashboard</title>
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="gplogofinal.png" type="png">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.4.1/dist/css/bootstrap.min.css" rel="stylesheet"> -->
    <!-- <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css"> -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.1.6/dist/sweetalert2.min.css">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- for icon -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css" rel="stylesheet">
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <!-- Buttons CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <!-- Bootstrap popup-->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="LifeAtGainup_Assets/assets/css/flatpickr.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/fixedcolumns/3.3.0/css/fixedColumns.dataTables.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/css/bootstrap-datepicker.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css">

    <style type="text/css">
        .navbar {
            background: #13265C;
        }

        .nav-link:hover {
            color: #9ffb00 !important;
        }

        .dropdown-menu.left {
            left: auto;
            right: 0;
        }

        .active {

            border-radius: 10px;
            color: #fff;
            font-weight: 500;
            border: 2px solid white;

        }

        body {
            /* padding-top: 50px;  */
            color: #1a202c;
            text-align: left;
            background-color: #e2e8f0;
        }

        .main-body {
            padding: 15px;
        }

        .card {
            box-shadow: 0 1px 3px 0 rgba(0, 0, 0, .1), 0 1px 2px 0 rgba(0, 0, 0, .06);
        }

        .card {
            position: relative;
            display: flex;
            flex-direction: column;
            min-width: 0;
            word-wrap: break-word;
            background-color: #fff;
            background-clip: border-box;
            border: 0 solid rgba(0, 0, 0, .125);
            border-radius: .25rem;
        }

        .card-body {
            flex: 1 1 auto;
            min-height: 1px;
            padding: 0rem;
        }

        .gutters-sm {
            margin-right: -8px;
            margin-left: -8px;
        }

        .gutters-sm>.col,
        .gutters-sm>[class*=col-] {
            padding-right: 8px;
            padding-left: 8px;
        }

        .mb-3,
        .my-3 {
            margin-bottom: 1rem !important;
        }

        .bg-gray-300 {
            background-color: #e2e8f0;
        }

        .h-100 {
            height: 100% !important;
        }

        .shadow-none {
            box-shadow: none !important;
        }

        .rounded {
            border-radius: 50%;
            border: 2px solid #ccc;
            cursor: pointer;

        }

        .profile-img {
            text-align: center;
        }

        .profile-img .file {
            position: relative;
            overflow: hidden;
            margin-top: -25%;
            width: 51%;
            border: none;
            border-radius: 0;
            font-size: 15px;
            background: #212529b8;
        }

        .profile-img .file input {
            position: absolute;
            opacity: 0;
            right: 0;
            top: 0;
        }

        .preloder {
            display: none;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999999;
            background: #ffffffbd;
            justify-content: center;
            align-items: center;
            display: flex;
        }

        .lds-hourglass,
        .lds-hourglass:after {
            box-sizing: border-box;
        }

        .lds-hourglass {
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: relative;
            width: 80px;
            height: 80px;
        }

        .lds-hourglass:after {
            content: " ";
            display: block;
            border-radius: 50%;
            width: 0;
            height: 0;
            margin: 8px;
            box-sizing: border-box;
            border: 32px solid currentColor;
            border-color: currentColor transparent currentColor transparent;
            animation: lds-hourglass 1.2s infinite;
        }

        @keyframes lds-hourglass {
            0% {
                transform: rotate(0);
                animation-timing-function: cubic-bezier(0.55, 0.055, 0.675, 0.19);
            }

            50% {
                transform: rotate(900deg);
                animation-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);
            }

            100% {
                transform: rotate(1800deg);
            }
        }

        .row {
            margin: 0 !important;
        }
    </style>

    <!-- <style>
        .red-container {
            background-color: #e9eef7;
            /* Light blue background */
            /* border: 2px solid red; */
            /* Red border */
            height: 100px;
            /* margin-bottom: 100px; */
            /* Adjust height to your preference */
            display: flex;
            /* Center content vertically and horizontally if needed */
            justify-content: center;
            align-items: center;
        }

        /* .container {
            margin-bottom: 100px;
        } */
    </style> -->

    <!-- CAP PLAN CARD -->
    <style>
        .capplTable {
            border-collapse: separate;
            border-spacing: 0;
            width: 200px;
            /* margin: 20px auto; */
            text-align: center;
            border: 1px solid #000;
            border-radius: 12px;
            overflow: hidden;
            height: 9px !important;
            background: white !important;
        }

        .capplThead {
            background-color: #f4f4f4;
        }

        .capplth {
            font-weight: bold;
            padding: 1px;
        }

        .cappltd {
            padding: 10px;
            padding-top: 0;
            padding-bottom: 8px;
            position: relative;
        }

        .cappl-row-heading {
            font-weight: bold;
            font-size: 14px;
            padding-top: 0;
            align-items: center;
            text-align: center;
            word-wrap: break-word;
            max-width: 200px;
        }

        .cappl-row-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .cappl-left {
            text-align: left;
        }

        .cappl-right {
            text-align: right;
            font-size: 24px;
            font-weight: bold;
        }

        .cappl-target {
            font-weight: bold;
            font-size: 14px;
            color: gray;
        }

        .cappl-percentage {
            display: flex;
            align-items: center;
            gap: 5px;
            font-size: 14px;
        }

        .cappl-percentage.green {
            color: green;
        }

        .cappl-percentage.red {
            color: red;
        }

        .cappl-arrow {
            font-size: 12px;
        }

        /* Dotted line separator */
        .cappltd:after {
            content: "";
            display: block;
            width: 90%;
            border-bottom: 1px dotted black;
        }

        /* Remove last dotted line */
        tr:last-child td:after {
            content: none;
        }

        #yearBtn,
        #monthBtn,
        #weekBtn {
            background: transparent;
            border: none;
            font-weight: 900;
            font-size: 15px;
        }
    </style>


    <style>
        .dropdown-item.active {
            background-color: #007bff;
            color: white;
        }
    </style>


    <style>
        .roundu {
            height: 120px;
            width: 200px;
            margin-top: 0;
            overflow: visible;
            /* overflow: hidden; */

        }

        .card-body.red-container {
            padding: 0;
        }

        .title-card {
            background-color: #72a3e0;
            padding: 0;
            border-radius: 2px;
        }



        #preloder {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999999;
            background: #ffffffbd;
            justify-content: center;
            align-items: center;
            display: flex;
        }

        .lds-hourglass,
        .lds-hourglass:after {
            box-sizing: border-box;
        }

        .lds-hourglass {
            display: inline-block;
            position: relative;
            width: 80px;
            height: 80px;
        }

        .lds-hourglass:after {
            content: " ";
            display: block;
            border-radius: 50%;
            width: 0;
            height: 0;
            margin: 8px;
            box-sizing: border-box;
            border: 32px solid currentColor;
            border-color: currentColor transparent currentColor transparent;
            animation: lds-hourglass 1.2s infinite;
        }

        @keyframes lds-hourglass {
            0% {
                transform: rotate(0);
                animation-timing-function: cubic-bezier(0.55, 0.055, 0.675, 0.19);
            }

            50% {
                transform: rotate(900deg);
                animation-timing-function: cubic-bezier(0.215, 0.61, 0.355, 1);
            }

            100% {
                transform: rotate(1800deg);
            }
        }
    </style>

    <!-- OWE CARD -->
    <style>
        .oweTable {
            border-collapse: separate;
            border-spacing: 0;
            width: 100px;
            text-align: center;
            border: 1px solid #000;
            border-radius: 12px;
            overflow: hidden;
            background: white !important;
        }

        .oweThead {
            background-color: #f4f4f4;
        }

        .oweth {
            font-weight: bold;
            padding: 0;
        }

        .owetd {
            padding: 10px;
            padding-top: 0;
            padding-bottom: 0;
            position: relative;
        }

        .owe-row-heading {
            font-weight: bold;
            font-size: 10px;
            padding-top: 0;
            align-items: center;
            text-align: center;
            word-wrap: break-word;
            max-width: 200px;
            /* padding-bottom: 5px;
            padding-top: 3px; */
        }

        .owe-row-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .owe-left {
            text-align: left;
        }

        .owe-right {
            text-align: right;
            font-size: 18px;
            font-weight: bold;
            padding-left: 5px;
        }

        .owe-target {
            font-weight: bold;
            font-size: 14px;
            color: gray;
        }

        .owe-percentage {
            display: flex;
            align-items: center;
            gap: 5px;
            font-size: 14px;
        }

        .owe-percentage.green {
            color: green;
        }

        .owe-percentage.red {
            color: red;
        }

        .owe-arrow {
            font-size: 12px;
        }

        /* Dotted line separator */
        .owetd:after {
            content: "";
            display: block;
            width: 90%;
            border-bottom: 1px dotted black;
        }

        /* Remove last dotted line */
        .owetr:last-child td:after {
            content: none;
        }

        #oweyearBtn,
        #owemonthBtn,
        #oweweekBtn,
        #oweQBtn,
        #oweDBtn {
            background: transparent;
            border: none;
            font-weight: 600;
            font-size: 12px;
            text-align: center;
            font-family: Inter;
        }
    </style>

    <style>
        /* .apexcharts-text, */
        .hexowe .apexcharts-xaxis-label {
            display: none;
        }

        .hexowe .apexcharts-legend {
            right: 0px !important;
            position: absolute !important;
            /* left: 0px !important; */
            top: 10px !important;
            max-height: 125px !important;
        }
        /* .firstChart .apexcharts-legend {
            display: none !important;
        } */
    </style>

    <style>
        /* Modal styles */
        .modal {
            display: none;
            /* Hidden by default */
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.8);
            /* Black background with opacity */
        }

        .modal-content {
            margin: auto;
            padding: 0;
            width: 90%;
            height: 90%;
            display: flex;
            justify-content: center;
            align-items: center;
            background-color: white;
            border-radius: 8px;
            overflow: hidden;
        }

        .close {
            position: absolute;
            right: 20px;
            top: 20px;
            color: #aaa;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }

        #chartContainer {
            width: 100%;
            height: 100%;
        }
    </style>

    <!-- BUYER DROPDOWN -->
    <style>
    .dropdown-menu {
        list-style: none;
        margin: 0;
        padding: 0;
    }

    .dropdown-menu li {
        padding: 0px 1px;
        cursor: pointer;
    }

    .dropdown-menu li a {
        text-decoration: none;
        color: #000;
        display: block;
    }

    .dropdown-menu li:hover {
        background-color: rgb(211, 219, 226);
    }

    .dropdown-submenu {
        position: relative;
    }

    .dropdown-submenu > .dropdown-menu {
        top: 0;
        left: 100%;
        margin-top: -6px;
        margin-left: 0;
        display: none;
    }

    .dropdown-submenu:hover > .dropdown-menu {
        display: block;
    }
</style>

    <!-- calendar icon hover -->
    <style>
        .calender_icon:hover i {
            color: black;
        }
    </style>

</head>

<body id="body" class="">
    <!-- spinner -->

    <!-- spinner end -->
    @apexchartsScripts
    @extends('LifeAtGainup.Navbar.Other_Chn')
    @section('content')

    <div class="row mt-2">
        <div class="card title-card">
            <div class="card-body" style="padding: 4px;">
                <h5 style="text-align: center; color: white;">
                    CXO Dashboard
                </h5>
            </div>
        </div>
    </div>



    <div class="firstChart row mt-2">


        <!-- 1st -->
        <div class="col-sm-4">
            <div class="card mt-2" style="padding: 1px;">
                <div class="card-body" style="height: 545px;">
                    <div style="display: flex; justify-content: space-between; align-items: center;background-color: #72a3e0; padding: 5px;">

                        
                        <button id="calendarIcon2" style="color: #fff;" class="btn btn-outline-light calender_icon">
                            <i class="fa-regular fa-calendar-days"></i>
                        </button>
                        <h6 style="color: #fff; text-align: center;"> Buyer Revenue Mgmt</h6>
                        <button id="optionsButton" class="btn optionsButton" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fa fa-industry" style="color: #fff;"></i>
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="optionsButton">
                            <li><a class="dropdown-item" href="#">Sales</a></li>
                            <li><a class="dropdown-item" href="#">Deposit</a></li>
                        </ul>
                        <img class="rounded-circle header-profile-user" height="40px" width="40px" src="{{ asset('frontend/img/userimg.png')}}" alt="Header Avatar">

                    </div>
                    <br>
                    {!! $chart->container() !!}
                    {!! $chart->script() !!}
                </div>
            </div>
        </div>

        <!-- 2nd -->
        <div class="col-sm-3 mt-0" style="height: 400px;">
            <div class="card mt-2" style="padding: 1px;">
                <div class="card-body">
                    <div style="display: flex; justify-content: space-between; align-items: center; background-color: #72a3e0; padding: 5px;">
                        
                        <button id="optionsButtoncal" style="color: #fff;" class="btn btn-outline-light calender_icon" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fa-regular fa-calendar-days"></i>
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="optionsButtoncal">
                             <!-- Month Submenu -->
                            <li class="dropdown-submenu">
                                <a class="dropdown-item dropdown-toggle" href="#">Month</a>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item calender active" data-value='month-24' onclick="changechart(this, 'month-24')" href="#">2024</a></li>
                                    <li><a class="dropdown-item calender" data-value='month-25' onclick="changechart(this, 'month-25')" href="#">2025</a></li>
                                </ul>
                            </li>
                            <!-- Week Submenu -->
                            <li class="dropdown-submenu">
                                <a class="dropdown-item dropdown-toggle" href="#">Week</a>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item calender" data-value='week-24' onclick="changechart(this, 'week-24')" href="#">2024</a></li>
                                    <li><a class="dropdown-item calender" data-value='week-25' onclick="changechart(this, 'week-25')" href="#">2025</a></li>
                                </ul>
                            </li>
                        </ul>

                        <h6 style="color: #fff; text-align: center;">{!! $HrbarChart->title !!}</h6>
                        <button id="optionsButton" class="btn optionsButton" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fa fa-industry" style="color: #fff;"></i>
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="optionsButton">
                            <li><a class="dropdown-item method active" data-value='mins' onclick="changechart(this,'mins');" href="#">Minutes</a></li>
                            <li><a class="dropdown-item method " data-value='qty' onclick="changechart( this,'qty');" href="#">Quantity</a></li>
                            <li><a class="dropdown-item method " data-value='values' onclick="changechart( this,'values');" href="#">Value</a></li>
                            <li><a class="dropdown-item method " data-value ='tailor' onclick="changechart( this,'tailor');" href="#">tailor</a></li>
                            <li><a class="dropdown-item method " data-value ='owe' onclick="changechart( this,'owe');" href="#">OWE</a></li>
                        </ul>
                        <button id='full_screen' class="btn optionsButton-user">
                            <i class="fa fa-arrows-alt" style="color: #fff;"></i>
                        </button>

                        <button id="optionsButton-user" class="btn optionsButton-user" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fa fa-user" style="color: #fff;"></i>
                        </button>
                        <ul class="dropdown-menu" id="buyerDropdown" aria-labelledby="optionsButton-user">
                            <li><a href="#" data-value="all">ALL</a></li> <!-- Add 'ALL' option -->
                            <!-- <li><a href="#" data-value="">Select Buyer</a></li> -->
                            @foreach($capacityQtyArr as $buyer)
                            @if($buyer['Buyer'] !== 'Total')
                            <li>
                                <a href="#" data-value="{{ $buyer['Buyer'] }}">{{ $buyer['Buyer'] }}</a>
                            </li>
                            @endif
                            @endforeach
                        </ul>
                        
                    </div>
                    <div style="height: 335px; display: flex; justify-content: center; align-items: center; overflow: hidden;">
                        <div id="preloder">
                            <div class="lds-hourglass">
                            </div>
                        </div>
                        {!! $HrbarChart->container() !!}
                    </div>
                    {!! $HrbarChart->script() !!}
                </div>
            </div>
        </div>

        <!-- 3rd -->
        <div class="col-sm-3" style="height: 400px;">
            <div class="col-lg-12">
                <div class="card mt-2" style="padding: 1px;">
                    <div class="card-body" style="height: 380px;"> <!-- Uniform height -->
                        <div style="display: flex; justify-content: space-between; align-items: center; background-color: #72a3e0; padding: 5px;">
                            
                            <button id="calendarIcon2" style="color: #fff;" class="btn btn-outline-light calender_icon">
                                <i class="fa-regular fa-calendar-days"></i>
                            </button>
                            <h6 style="color: #fff; text-align: center;"> Cost Analysis</h6>
                            <button id="optionsButton" class="btn optionsButton" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa fa-industry" style="color: #fff;"></i>
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="optionsButton">
                                <li><a class="dropdown-item" href="#">Sales</a></li>
                                <li><a class="dropdown-item" href="#">Deposit</a></li>
                            </ul>
                            <button id="optionsButton-user-cost" class="btn optionsButton-user-cost" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fa fa-user" style="color: #fff;"></i>
                            </button>
                        </div>
                        <br>
                        <div style="height: 300px;width: 280px; display: flex; justify-content: center; align-items: center; overflow: hidden;">
                            {!! $HrbarChartStatic->container() !!}
                        </div>
                        {!! $HrbarChartStatic->script() !!}
                    </div>
                </div>
            </div>

        </div>



        <!-- 4th -->
        <div class="col-sm-2">
            <table class="capplTable mt-2">
                <thead class="capplThead">
                    <tr class="cappltr">
                        <th class="capplth" title="Year">
                            <button id="yearBtn" class="btn btn-outline-none">
                                Y
                            </button>
                            <select id="year" name="year">
                                <option value="">Select Year</option>
                            </select>
                        </th>
                        <th class="capplth" title="Month">
                            <button id="monthBtn" class="btn btn-outline-none">
                                M
                            </button>
                            <input type="month" id="month" name="month" style="display:none;">
                        </th>
                        <th class="capplth" title="Week">
                            <button id="weekBtn" class="btn btn-outline-none">
                                W
                            </button>
                            <input type="week" id="week" name="week" style="display:none;">
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="cappltr">
                        <td class="cappltd" colspan="3">
                            <div class="cappl-row-heading">Delivery on Time</div>
                            <div class="cappl-row-content">
                                <div class="cappl-left">
                                    <div class="cappl-target">Target</div>
                                    <div class="cappl-percentage green">
                                        <span class="cappl-arrow">▲</span>
                                        <span>2.4%</span>
                                    </div>
                                </div>
                                <div class="owe-right">
                                    100%
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr class="cappltr">
                        <td class="cappltd" colspan="3">
                            <div class="cappl-row-heading">Unit Wised Capacity</div>
                            <div class="cappl-row-content">
                                <div class="cappl-left">
                                    <div class="cappl-target">Target</div>
                                    <div class="cappl-percentage green">
                                        <span class="cappl-arrow">▲</span>
                                        <span>3.4%</span>
                                    </div>
                                </div>
                                <div class="owe-right">
                                    200%
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr class="cappltr">
                        <td class="cappltd" colspan="3">
                            <div class="cappl-row-heading">CK on Time</div>
                            <div class="cappl-row-content">
                                <div class="cappl-left">
                                    <div class="cappl-target">Target</div>
                                    <div class="cappl-percentage red">
                                        <span class="cappl-arrow">▼</span>
                                        <span>1.5%</span>
                                    </div>
                                </div>
                                <div class="owe-right">
                                    300%
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr class="cappltr">
                        <td class="cappltd" colspan="3">
                            <div class="cappl-row-heading">Planning Accuracy</div>
                            <div class="cappl-row-content">
                                <div class="cappl-left">
                                    <div class="cappl-target">Target</div>
                                    <div class="cappl-percentage green">
                                        <span class="cappl-arrow">▲</span>
                                        <span>3.4%</span>
                                    </div>
                                </div>
                                <div class="owe-right">
                                    400%
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr class="cappltr">
                        <td class="cappltd" colspan="3">
                            <div class="cappl-row-heading">Changeovers</div>
                            <div class="cappl-row-content">
                                <div class="cappl-left">
                                    <div class="cappl-target">Target</div>
                                    <div class="cappl-percentage green">
                                        <span class="cappl-arrow">▲</span>
                                        <span>3.4%</span>
                                    </div>
                                </div>
                                <div class="owe-right">
                                    500%
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
            <!-- 4th -->
            <div class="col-lg-12">
                <div class="container">
                    <div class="card mt-3" style="padding: 2px; float: right; width: 475%; height:135px">
                        <div class="row">
                            <div class="col-lg-3">
                                <div class="card-body red-container">
                                    <div class="roundu">
                                        {!! $grp_donut->container() !!}
                                    </div>
                                    {!! $grp_donut->script() !!}

                                </div>
                            </div>
                            <br>
                            <div class="col-lg-3">
                                <div class="roundu">
                                    {!! $grp1_donut->container() !!}

                                </div>
                                {!! $grp1_donut->script() !!}
                            </div>
                            <br>
                            <div class="col-lg-3">
                                <div class="roundu">
                                    {!! $grp2_donut->container() !!}
                                </div>
                                {!! $grp2_donut->script() !!}
                            </div>
                            <br>
                            <div class="col-lg-3">
                                <div class="roundu">
                                    {!! $grp3_donut->container() !!}
                                </div>
                                {!! $grp3_donut->script() !!}
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </div>


    <!-- OWE CHART -->
    <div class="mt-3 ml-2" style="width: 1054px; height: 247px; position: relative; background:white !important;">

        <div style="width: 1053px; height: 247px; left: 0px; top: 0px; position: absolute; border-radius: 5px; border: 1px black solid"></div>

        <!-- HEADING -->
        <div style="width: 1053px; height: 27px; left: 1px; top: 0px; position: absolute; background: #5927E5; border-radius: 5px">
            <div style="left: 245px; top: 5px; position: absolute; text-align: center; color: white; font-size: 15px; font-family: Inter; font-weight: 700; word-wrap: break-word">OWE vs. DHU</div>
            <div style="left: 836px; top: 5px; position: absolute; text-align: center; color: white; font-size: 15px; font-family: Inter; font-weight: 700; word-wrap: break-word">Critical Defects</div>
            <div style="left: 575px; top: 5px; position: absolute; text-align: center; color: white; font-size: 15px; font-family: Inter; font-weight: 700; word-wrap: break-word">Top 5 defects</div>
        </div>

        <!-- FIRST ITEM - CARD -->
        <div style="width: 114px; height: 184px; left: 17px; top: 44px; position: absolute">
            <div>
                <table class="oweTable">
                    <thead class="oweThead">
                        <tr class="owetr">
                            <th class="oweth" title="Year">
                                <button id="oweyearBtn" class="">
                                    Y
                                </button>
                                <select id="year" name="year" style="display: none;">
                                    <option value="">Select Year</option>
                                </select>
                            </th>
                            <th class="oweth" title="Q">
                                <button id="oweQBtn" class="">
                                    Q
                                </button>
                                <input type="Q" id="Q" name="Q" style="display:none;">
                            </th>
                            <th class="oweth" title="Month">
                                <button id="owemonthBtn" class="">
                                    M
                                </button>
                                <input type="month" id="month" name="month" style="display:none;">
                            </th>
                            <th class="oweth" title="Week">
                                <button id="oweweekBtn" class="">
                                    W
                                </button>
                                <input type="week" id="week" name="week" style="display:none;">
                            </th>
                            <th class="oweth" title="D">
                                <button id="oweDBtn" class="">
                                    D
                                </button>
                                <input type="D" id="D" name="D" style="display:none;">
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="owetr">
                            <td class="owetd" colspan="6">
                                <div class="owe-row-heading">Rework WIP</div>
                                <div class="owe-row-content">
                                    <div class="owe-left">
                                        <div class="owe-target">Target</div>
                                        <div class="owe-percentage green">
                                            <span class="owe-arrow">▲</span>
                                            <span>2.4%</span>
                                        </div>
                                    </div>
                                    <div class="owe-right">
                                        100%
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr class="owetr">
                            <td class="owetd" colspan="6">
                                <div class="owe-row-heading">Rejection</div>
                                <div class="owe-row-content">
                                    <div class="owe-left">
                                        <div class="owe-target">Target</div>
                                        <div class="owe-percentage green">
                                            <span class="owe-arrow">▲</span>
                                            <span>3.4%</span>
                                        </div>
                                    </div>
                                    <div class="owe-right">
                                        200%
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr class="owetr">
                            <td class="owetd" colspan="6">
                                <div class="owe-row-heading">Final Inspection</div>
                                <div class="owe-row-content">
                                    <div class="owe-left">
                                        <div class="owe-target">Target</div>
                                        <div class="owe-percentage red">
                                            <span class="owe-arrow">▼</span>
                                            <span>1.5%</span>
                                        </div>
                                    </div>
                                    <div class="owe-right">
                                        300%
                                    </div>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- SECOND ITEM - CHART -->
        <div class='hexowe' style="width: 300px; height: 200px; left: 155px; top: 47px; position: absolute">
            {!! $HrOweDhu->container() !!}
            {!! $HrOweDhu->script() !!}
        </div>

        <!-- THIRD ITEM - CHART -->
        <div style="width: 220px; height: 196px; left: 504px; top: 33px; position: absolute">
            <!-- UPPER -->
            <div style="width: 218.50px; height: 98px; left: 0px; top: 0px; position: absolute">
                <div style="left: 44px; top: 12px; position: absolute; text-align: center; color: black; font-size: 8px; font-family: Inter; font-weight: 400; word-wrap: break-word">Shape off</div>
                <div style="left: 44px; top: 30px; position: absolute; text-align: center; color: black; font-size: 8px; font-family: Inter; font-weight: 400; word-wrap: break-word">Bottom Hiking</div>
                <div style="left: 44px; top: 48px; position: absolute; text-align: center; color: black; font-size: 8px; font-family: Inter; font-weight: 400; word-wrap: break-word">Print Defect</div>
                <div style="left: 44px; top: 66px; position: absolute; text-align: center; color: black; font-size: 8px; font-family: Inter; font-weight: 400; word-wrap: break-word">Set Uneven</div>
                <div style="left: 44px; top: 84px; position: absolute; text-align: center; color: black; font-size: 8px; font-family: Inter; font-weight: 400; word-wrap: break-word">Asymmetrical </div>
                <div style="width: 28px; height: 88px; left: 3px; top: 10px; position: absolute; background: #5927E5; border-radius: 5px"></div>
                <div style="left: 11px; top: 90px; position: absolute; transform: rotate(-90deg); transform-origin: 0 0; text-align: center; color: #FFFCFC; font-size: 10px; font-family: Inter; font-weight: 700; word-wrap: break-word">Cut Panel</div>
                <div style="width: 179.50px; height: 0px; left: 39px; top: 26px; position: absolute; border: 0.50px #565656 dotted"></div>
                <div style="width: 179.50px; height: 0px; left: 39px; top: 44px; position: absolute; border: 0.50px #565656 dotted"></div>
                <div style="width: 179.50px; height: 0px; left: 39px; top: 62px; position: absolute; border: 0.50px #565656 dotted"></div>
                <div style="width: 179.50px; height: 0px; left: 39px; top: 80px; position: absolute; border: 0.50px #565656 dotted"></div>
                <div style="width: 179.50px; height: 0px; left: 39px; top: 98px; position: absolute; border: 0.50px #565656 dotted"></div>
                <div style="left: 172px; top: 15px; position: absolute; text-align: center; color: #00C324; font-size: 7px; font-family: Inter; font-weight: 400; word-wrap: break-word">2%</div>
                <div style="left: 172px; top: 15px; position: absolute; text-align: center; color: #00C324; font-size: 7px; font-family: Inter; font-weight: 400; word-wrap: break-word">2%</div>
                <div style="left: 173px; top: 34px; position: absolute; text-align: center; color: #FF3434; font-size: 7px; font-family: Inter; font-weight: 400; word-wrap: break-word">1%</div>
                <div style="left: 172px; top: 52px; position: absolute; text-align: center; color: #00C324; font-size: 7px; font-family: Inter; font-weight: 400; word-wrap: break-word">4%</div>
                <div style="left: 172px; top: 70px; position: absolute; text-align: center; color: #00C324; font-size: 7px; font-family: Inter; font-weight: 400; word-wrap: break-word">2%</div>
                <div style="left: 172px; top: 88px; position: absolute; text-align: center; color: #FF3434; font-size: 7px; font-family: Inter; font-weight: 400; word-wrap: break-word">5%</div>
                <div style="left: 194px; top: 11px; position: absolute; text-align: center; color: black; font-size: 12px; font-family: Inter; font-weight: 700; word-wrap: break-word">12%</div>
                <div style="left: 193px; top: 27px; position: absolute; text-align: center; color: black; font-size: 12px; font-family: Inter; font-weight: 700; word-wrap: break-word">10%</div>
                <div style="left: 199px; top: 45px; position: absolute; text-align: center; color: black; font-size: 12px; font-family: Inter; font-weight: 700; word-wrap: break-word">9%</div>
                <div style="left: 200px; top: 63px; position: absolute; text-align: center; color: black; font-size: 12px; font-family: Inter; font-weight: 700; word-wrap: break-word">7%</div>
                <div style="left: 199px; top: 82px; position: absolute; text-align: center; color: black; font-size: 12px; font-family: Inter; font-weight: 700; word-wrap: break-word">3%</div>
                <div style="width: 20px; height: 5px; left: 162px; top: 10px; position: absolute; background: #FF007F; border-radius: 1px"></div>
                <div style="width: 20px; height: 5px; left: 162px; top: 10px; position: absolute; background: #FF007F; border-radius: 1px"></div>
                <div style="width: 20px; height: 5px; left: 162px; top: 29px; position: absolute; background: #FF007F; border-radius: 1px"></div>
                <div style="width: 20px; height: 5px; left: 162px; top: 47px; position: absolute; background: #FF007F; border-radius: 1px"></div>
                <div style="width: 20px; height: 5px; left: 162px; top: 65px; position: absolute; background: #FF007F; border-radius: 1px"></div>
                <div style="width: 20px; height: 5px; left: 162px; top: 83px; position: absolute; background: #FF007F; border-radius: 1px"></div>
                <div style="width: 16px; height: 5px; left: 162px; top: 83px; position: absolute; background: #5927E5; border-radius: 1px"></div>
                <div style="width: 10px; height: 5px; left: 162px; top: 10px; position: absolute; background: #5927E5; border-radius: 1px"></div>
                <div style="width: 10px; height: 5px; left: 162px; top: 10px; position: absolute; background: #5927E5; border-radius: 1px"></div>
                <div style="width: 16px; height: 5px; left: 162px; top: 29px; position: absolute; background: #5927E5; border-radius: 1px"></div>
                <div style="width: 4px; height: 5px; left: 162px; top: 47px; position: absolute; background: #5927E5; border-radius: 1px"></div>
                <div style="width: 34px; height: 34px; left: 0px; top: 0px; position: absolute; background: white; border-radius: 9999px; border: 2px #5927E5 solid"></div>
                <div style="left: 5px; top: 9px; position: absolute; text-align: center; color: #FF007F; font-size: 12px; font-family: Inter; font-weight: 800; word-wrap: break-word">41%</div>
            </div>
            <!-- LOWER -->
            <div style="width: 220px; height: 95px; left: 0px; top: 101px; position: absolute">
                <div style="left: 44px; top: 9px; position: absolute; text-align: center; color: black; font-size: 8px; font-family: Inter; font-weight: 400; word-wrap: break-word">Shape off</div>
                <div style="left: 44px; top: 27px; position: absolute; text-align: center; color: black; font-size: 8px; font-family: Inter; font-weight: 400; word-wrap: break-word">Bottom Hiking</div>
                <div style="left: 44px; top: 45px; position: absolute; text-align: center; color: black; font-size: 8px; font-family: Inter; font-weight: 400; word-wrap: break-word">Print Defect</div>
                <div style="left: 44px; top: 63px; position: absolute; text-align: center; color: black; font-size: 8px; font-family: Inter; font-weight: 400; word-wrap: break-word">Set Uneven</div>
                <div style="left: 44px; top: 81px; position: absolute; text-align: center; color: black; font-size: 8px; font-family: Inter; font-weight: 400; word-wrap: break-word">Asymmetrical </div>
                <div style="width: 28px; height: 88px; left: 3px; top: 7px; position: absolute; background: #5927E5; border-radius: 5px"></div>
                <div style="left: 10px; top: 86px; position: absolute; transform: rotate(-90deg); transform-origin: 0 0; text-align: center; color: #FFFCFC; font-size: 10px; font-family: Inter; font-weight: 700; word-wrap: break-word">Sewing</div>
                <div style="width: 179.50px; height: 0px; left: 39px; top: 23px; position: absolute; border: 0.50px #565656 dotted"></div>
                <div style="width: 179.50px; height: 0px; left: 39px; top: 41px; position: absolute; border: 0.50px #565656 dotted"></div>
                <div style="width: 179.50px; height: 0px; left: 39px; top: 59px; position: absolute; border: 0.50px #565656 dotted"></div>
                <div style="width: 179.50px; height: 0px; left: 39px; top: 77px; position: absolute; border: 0.50px #565656 dotted"></div>
                <div style="width: 179.50px; height: 0px; left: 39px; top: 95px; position: absolute; border: 0.50px #565656 dotted"></div>
                <div style="left: 172px; top: 12px; position: absolute; text-align: center; color: #00C324; font-size: 7px; font-family: Inter; font-weight: 400; word-wrap: break-word">2%</div>
                <div style="left: 172px; top: 12px; position: absolute; text-align: center; color: #00C324; font-size: 7px; font-family: Inter; font-weight: 400; word-wrap: break-word">2%</div>
                <div style="left: 173px; top: 31px; position: absolute; text-align: center; color: #FF3434; font-size: 7px; font-family: Inter; font-weight: 400; word-wrap: break-word">1%</div>
                <div style="left: 172px; top: 49px; position: absolute; text-align: center; color: #00C324; font-size: 7px; font-family: Inter; font-weight: 400; word-wrap: break-word">4%</div>
                <div style="left: 172px; top: 67px; position: absolute; text-align: center; color: #00C324; font-size: 7px; font-family: Inter; font-weight: 400; word-wrap: break-word">2%</div>
                <div style="left: 172px; top: 85px; position: absolute; text-align: center; color: #FF3434; font-size: 7px; font-family: Inter; font-weight: 400; word-wrap: break-word">5%</div>
                <div style="left: 196px; top: 8px; position: absolute; text-align: center; color: black; font-size: 12px; font-family: Inter; font-weight: 700; word-wrap: break-word">15%</div>
                <div style="left: 195px; top: 24px; position: absolute; text-align: center; color: black; font-size: 12px; font-family: Inter; font-weight: 700; word-wrap: break-word">14%</div>
                <div style="left: 196px; top: 42px; position: absolute; text-align: center; color: black; font-size: 12px; font-family: Inter; font-weight: 700; word-wrap: break-word">12%</div>
                <div style="left: 195px; top: 60px; position: absolute; text-align: center; color: black; font-size: 12px; font-family: Inter; font-weight: 700; word-wrap: break-word">10%</div>
                <div style="left: 201px; top: 79px; position: absolute; text-align: center; color: black; font-size: 12px; font-family: Inter; font-weight: 700; word-wrap: break-word">8%</div>
                <div style="width: 20px; height: 5px; left: 162px; top: 7px; position: absolute; background: #FF007F; border-radius: 1px"></div>
                <div style="width: 20px; height: 5px; left: 162px; top: 7px; position: absolute; background: #FF007F; border-radius: 1px"></div>
                <div style="width: 20px; height: 5px; left: 162px; top: 26px; position: absolute; background: #FF007F; border-radius: 1px"></div>
                <div style="width: 20px; height: 5px; left: 162px; top: 44px; position: absolute; background: #FF007F; border-radius: 1px"></div>
                <div style="width: 20px; height: 5px; left: 162px; top: 62px; position: absolute; background: #FF007F; border-radius: 1px"></div>
                <div style="width: 20px; height: 5px; left: 162px; top: 80px; position: absolute; background: #FF007F; border-radius: 1px"></div>
                <div style="width: 16px; height: 5px; left: 162px; top: 80px; position: absolute; background: #5927E5; border-radius: 1px"></div>
                <div style="width: 10px; height: 5px; left: 162px; top: 7px; position: absolute; background: #5927E5; border-radius: 1px"></div>
                <div style="width: 10px; height: 5px; left: 162px; top: 7px; position: absolute; background: #5927E5; border-radius: 1px"></div>
                <div style="width: 16px; height: 5px; left: 162px; top: 26px; position: absolute; background: #5927E5; border-radius: 1px"></div>
                <div style="width: 4px; height: 5px; left: 162px; top: 44px; position: absolute; background: #5927E5; border-radius: 1px"></div>
                <div style="width: 34px; height: 34px; left: 0px; top: 0px; position: absolute; background: white; border-radius: 9999px; border: 2px #5927E5 solid"></div>
                <div style="left: 4px; top: 9px; position: absolute; text-align: center; color: #FF007F; font-size: 12px; font-family: Inter; font-weight: 800; word-wrap: break-word">59%</div>
            </div>
        </div>

        <!-- FOURTH ITEM - CHART -->
        <div class='hexowe' style="width: 300px; height: 200px; left: 744px; top: 47px; position: absolute">
            {!! $criticalDefectChart->container() !!}
            {!! $criticalDefectChart->script() !!}
        </div>

    </div>


    <!-- Modal Container -->
    <div id="chartModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <div class="card">
                <div class="card-header">
                    <h3>Chart Title</h3>
                </div>
                <div class="card-body">
                    <div id="chartContainer"></div>
                </div>
            </div>
        </div>
    </div>



    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <!-- DataTables JS -->

    <script src="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/js/bootstrap-datepicker.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <!-- chart plugin  -->

    <!-- CALENDAR -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

    <script>
        // Initialize Date Range Picker for the first chart
        $('#calendarIcon1').daterangepicker({
            singleDatePicker: true,
            showDropdowns: true,
            locale: {
                format: 'MM/DD/YYYY'
            }
        }, function(start, end, label) {
            console.log('Selected date: ' + start.format('MM/DD/YYYY'));
            // Update the chart based on the selected date
        });

        // Initialize Date Range Picker for the second chart
        $('#calendarIcon2').daterangepicker({
            singleDatePicker: true,
            showDropdowns: true,
            locale: {
                format: 'MM/DD/YYYY'
            }
        }, function(start, end, label) {
            console.log('Selected date: ' + start.format('MM/DD/YYYY'));
            // Update the chart based on the selected date
        });
    </script>

    <script>
        var chartOptions = @json(config('apexcharts.options'));
        var chart = new ApexCharts(document.querySelector("#chart"), chartOptions);
        chart.render();
    </script>


<script>
    window.onload = function() {
            // Populate Year dropdown
            let yearSelect = document.getElementById('year');
            let currentYear = new Date().getFullYear();
            let startYear = 2023;

            for (let year = startYear; year <= currentYear; year++) {
                let option = document.createElement('option');
                option.value = year;
                option.textContent = year;
                yearSelect.appendChild(option);
            }

            // Initially hide the year select dropdown
            yearSelect.style.display = 'none';

            // Show the year dropdown when the year button is clicked
            document.getElementById('yearBtn').addEventListener('click', function() {
                // Toggle visibility of the year select dropdown
                yearSelect.style.display = (yearSelect.style.display === 'none') ? 'block' : 'none';
            });

            // Show the month picker when the month button is clicked
            let monthInput = document.getElementById('month');
            document.getElementById('monthBtn').addEventListener('click', function() {
                // Toggle the visibility of the month input field
                if (monthInput.style.display === 'none') {
                    monthInput.style.display = 'block'; // Show the month input field
                    monthInput.focus(); // Focus the input field
                    monthInput.style.display = 'none'; // Show the month input field
                    monthInput.showPicker(); // Open the month picker
                } else {
                    monthInput.style.display = 'none'; // Hide the month input field
                }
            });

            // Show the week picker when the week button is clicked
            let weekInput = document.getElementById('week');
            document.getElementById('weekBtn').addEventListener('click', function() {
                if (weekInput.style.display === 'none') {
                    weekInput.style.display = 'block'; // Show the month input field
                    weekInput.focus(); // Focus the input field
                    weekInput.style.display = 'none'; // Show the month input field
                    weekInput.showPicker(); // Open the month picker
                } else {
                    weekInput.style.display = 'none'; // Hide the month input field
                }
            });
    };
    let filteredQtyDataarr = []; // Default empty array
    let Qtycolumnsarr = []; // Default empty array

function changechart(element, chartType) {
    var value = chartType;
    var val = chartType;

    if (element.classList.contains('calender')) {
        const dropdownItemsCalender = document.querySelectorAll('.dropdown-item.calender');
        dropdownItemsCalender.forEach(item => item.classList.remove('active'));
    }

    if (element.classList.contains('method')) {
        const dropdownItemsMethod = document.querySelectorAll('.dropdown-item.method');
        dropdownItemsMethod.forEach(item => item.classList.remove('active'));
    }

    element.classList.add('active');

    const activeItems = document.querySelectorAll('.calender.active, .method.active');
    const activeValues = Array.from(activeItems).reduce((result, item) => {
        if (item.classList.contains('calender')) {
            result.calender = item.getAttribute('data-value');
        } else if (item.classList.contains('method')) {
            result.method = item.getAttribute('data-value');
        }
        return result;
    }, {});
    //var val = $('.dropdown-item .method .active').attr('data-value');
    const methodValue = activeValues.method;
    const calender = activeValues.calender;
    const parts = calender.split('-');
    const numbercalender = parts[1];

  var val = methodValue;

    $.ajax({
        url: '{{ route("capacitymonthwish") }}',
        method: 'GET',
        data: activeValues,
        beforeSend: function () {
                    $("#preloder").fadeIn();
                        },
        success: function(response) {
            var capacityQtyArr = response.capacitymonth;

            // Update global variables instead of redefining them
            filteredQtyDataarr = capacityQtyArr.filter(item => item.Buyer !== "Total");
           console.log(filteredQtyDataarr);
           populateBuyerDropdown(filteredQtyDataarr);
            
            if (value == 'week-24' || value == 'week-25') {
                Qtycolumnsarr = Object.keys(filteredQtyDataarr[0]);
            } else {
                Qtycolumnsarr = Object.keys(filteredQtyDataarr[0]).filter(key => key.match(/^[A-Za-z]{3}_\d{4}$/));
            }

            var Qtycategories = Qtycolumnsarr.map(col => col.split('_')[0]);
            var formattedQtyData = filteredQtyDataarr.map(item => ({
                name: item.Buyer,
                data: Qtycolumnsarr.map(col => parseInt(item[col]) || 0)
            }));

            chart_{{ $HrbarChart->getId() }}.updateSeries(formattedQtyData);

            var xAxisLabel = "";
            var yAxisLabel = "";
            if (val === 'mins') {
                xAxisLabel = 'Months';
                yAxisLabel = 'Booking Mins-('+numbercalender + ')';
            }else if (val === 'qty') {
                xAxisLabel = 'Months';
                yAxisLabel = 'Booking Qty-('+numbercalender + ')';;
            }else if (val == 'values'){
                xAxisLabel = 'Months';
                yAxisLabel = 'Booking Values-('+numbercalender + ')';;
            } else if (val == 'tailor'){
                xAxisLabel = 'Months';
                yAxisLabel = 'Tailor -('+numbercalender + ')';;
            }
            else if (val == 'owe'){
                xAxisLabel = 'Months';
                yAxisLabel = 'OWE -('+numbercalender + ')';;
            }



            chart_{{ $HrbarChart->getId() }}.updateOptions({
                
                xaxis: {
                    categories: Qtycategories,
                    title: { text: xAxisLabel },
                    labels: { formatter: function(value) { return value; } }
                },
                yaxis: {
                    title: { text: yAxisLabel },
                    labels: {
                        formatter: function(value) {
                            if (value >= 1000000) return (value / 1000000).toFixed(1) + 'M';
                            else if (value >= 1000) return (value / 1000).toFixed(1) + 'K';
                            else return value.toLocaleString();
                        }
                    }
                },
                
                plotOptions: {
                    bar: {
                        dataLabels: {
                            enabled: true,
                            formatter: function(value) {
                                if (value >= 1000000) return (value / 1000000).toFixed(1) + 'M';
                                else if (value >= 1000) return (value / 1000).toFixed(1) + 'K';
                                else return value.toLocaleString();
                            }
                        }
                    }
                },
                tooltip: {
                    y: {
                        formatter: function(value) {
                            if (value >= 1000000) return (value / 1000000).toFixed(1) + 'M';
                            else if (value >= 1000) return (value / 1000).toFixed(1) + 'K';
                            else return value.toLocaleString();
                        }
                    }
                }
            });
        },
        error: function() {
            console.log("Error fetching data.");
        },
        complete: function () {
                    $("#preloder").fadeOut();
                   
                }
    });
}

function updateChartForBuyerNew(selectedBuyer) {
    console.log(selectedBuyer);
    if (filteredQtyDataarr.length === 0 || Qtycolumnsarr.length === 0) {
        console.error("Data is not loaded yet. Please wait for the AJAX response.");
        return;
    }
    if(selectedBuyer == 'one' || selectedBuyer == 'all'){
        var singleBuyerData = filteredQtyDataarr.filter(item => item.Buyer !== "Total");
    }else{
        var singleBuyerData = filteredQtyDataarr.filter(item => item.Buyer === selectedBuyer);
    }
   
    var formattedQtyData = singleBuyerData.map(item => ({
        name: item.Buyer,
        data: Qtycolumnsarr.map(col => parseInt(item[col]) || 0)
    }));

    // Modal references
    var modal = document.getElementById('chartModal');
    var closeButton = document.querySelector('.close');

    // Show the modal
    modal.style.display = "block";

    // Prepare chart options for the modal
    const chartOptions = {
    chart: {
        type: 'bar',
        background: '#f4f4f4', // Set the background color to gray
        height: 600, // Set the overall height of the chart
        width: 1200,
        stacked: true,
        animations: {
            enabled: true // Enable animations for modal rendering
        }
    },
    plotOptions: {
        bar: {
            horizontal: false, // Set to true if you want horizontal bars
            columnWidth: '50%', // Adjusts the width of the bars
            borderRadius: 5, // Adds rounded corners to bars
            dataLabels: {
                enabled: true, // Enable data labels on bars
                style: {
                    colors: ['#000000'], // Set the color of the bar labels (white text)
                    fontSize: '14px', // Set font size for the bar labels
                    fontWeight: 'bold', // Set font weight to bold for the bar labels
                    fontFamily: 'Arial, sans-serif', // Set font family (optional)
                    textOutline: '2px solid #000000' // Stroke (outline) effect for the text
                },
                formatter: function (value) {
                    // Format the value displayed on the bars
                    return value >= 1000000 ? (value / 1000000).toFixed(1) + 'M' :
                        value >= 1000 ? (value / 1000).toFixed(1) + 'K' : value;
                }
            }
        }
    },
    xaxis: {
        categories: Qtycolumnsarr.map(col => col.split('_')[0]),
        labels: {
            show: true, // Ensure labels are shown
            style: {
                colors: '#333333', // Set color of X-axis labels (dark gray)
                fontSize: '14px', // Optional: Set font size for X-axis labels
                fontWeight: 'bold' // Optional: Set font weight for X-axis labels
            }
        },
        axisBorder: {
            show: true,
            color: '#000000', // Bold black color for X-axis border
            height: 2 // Thicker border for emphasis
        },
        axisTicks: {
            show: true,
            color: '#000000' // Black ticks to match bold style
        }
    },
    yaxis: {
        labels: {
            show: true, // Ensure Y-axis labels are visible
            style: {
                colors: '#333333', // Set color of Y-axis labels (dark gray)
                fontSize: '14px', // Optional: Set font size for Y-axis labels
                fontWeight: 'bold' // Optional: Set font weight for Y-axis labels
            },
            formatter: function (value) {
                // Format the Y-axis labels to show in 'K' or 'M'
                return value >= 1000000 ? (value / 1000000).toFixed(1) + 'M' :
                    value >= 1000 ? (value / 1000).toFixed(1) + 'K' : value;
            }
        },
        axisBorder: {
            show: true,
            color: '#000000', // Bold black color for Y-axis border
        },
        axisTicks: {
            show: true,
            color: '#000000' // Black ticks for Y-axis
        }
    },
    series: formattedQtyData
    };

    // Render chart
    const chart = new ApexCharts(document.querySelector("#chartContainer"), chartOptions);
    chart.render();

    // Close modal functionality
    closeButton.onclick = function () {
        modal.style.display = "none";
        chart.destroy(); // Destroy the chart when closing the modal
    };

    // Close modal when clicking outside the modal content
    window.onclick = function (event) {
        if (event.target === modal) {
            modal.style.display = "none";
            chart.destroy(); // Destroy the chart when closing the modal
        }
    };

    // Optionally add escape key to close modal
    window.onkeydown = function (event) {
        if (event.key === "Escape") {
            modal.style.display = "none";
            chart.destroy(); // Destroy the chart when closing the modal
        }
    };
}

let selectedBuyer='';
function updateChartForBuyer(selectedBuyer) {
    if (filteredQtyDataarr.length === 0 || Qtycolumnsarr.length === 0) {
        console.error("Data is not loaded yet. Please wait for the AJAX response.");
        return;
    }

    if(selectedBuyer != 'all'){
        var singleBuyerData = filteredQtyDataarr.filter(item => item.Buyer === selectedBuyer);
    }else{
        var singleBuyerData = filteredQtyDataarr.filter(item => item.Buyer !== "Total");
    }
    
    var formattedQtyData = singleBuyerData.map(item => ({
        name: item.Buyer,
        data: Qtycolumnsarr.map(col => parseInt(item[col]) || 0)
    }));

    chart_{{ $HrbarChart->getId() }}.updateSeries(formattedQtyData);
}

document.getElementById('buyerDropdown').addEventListener('click', function (event) {
    const target = event.target;

    // Ensure the clicked element is a link within the dropdown
    if (target.tagName === 'A') {
        event.preventDefault(); // Prevent default anchor behavior
        selectedBuyer = target.getAttribute('data-value'); // Get the buyer value
        console.log("Selected Buyer:", selectedBuyer); // Debugging
        updateChartForBuyer(selectedBuyer); // Call your chart update function
    }
});

// Function to dynamically populate dropdown with <li>
function populateBuyerDropdown(filteredQtyData) {
    const buyerDropdown = document.getElementById("buyerDropdown");
    buyerDropdown.innerHTML = ''; // Clear existing dropdown items

    // Add default option
    // const defaultItem = document.createElement('li');
    // defaultItem.innerHTML = `<a href="#" data-value="">Select Buyer</a>`;
    // buyerDropdown.appendChild(defaultItem);

    // Add "ALL" option
    const allItem = document.createElement('li');
    allItem.innerHTML = `<a href="#" data-value="all">ALL</a>`;
    buyerDropdown.appendChild(allItem);

    // Extract unique buyers and populate dropdown
    const buyers = filteredQtyData.map(item => item.Buyer);
    const uniqueBuyers = [...new Set(buyers)];
    uniqueBuyers.forEach(buyer => {
        const listItem = document.createElement('li');
        listItem.innerHTML = `<a href="#" data-value="${buyer}">${buyer}</a>`;
        buyerDropdown.appendChild(listItem);
    });
}

$('#full_screen').click(function () {
    if(selectedBuyer==''){
        updateChartForBuyerNew('one');
    }else{
        updateChartForBuyerNew(selectedBuyer);
    }
});


   
    document.addEventListener("DOMContentLoaded", function () {
        const activeItem = document.querySelector(".dropdown-item.method.active");
        if (activeItem) {
            activeItem.click(); 
        } else {
            console.log("Active item not found!");
        }
    }); 

    </script>


    @endsection
</body>

</html>